/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.tools;

import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Timer;
import jgamebase.Const;
import jgamebase.tools.FileTools;

public abstract class DownloadTools {
    public static boolean downloadUriToFile(URI uri, File file) {
        String oldValueOf_useSystemProxies = System.getProperty("java.net.useSystemProxies");
        HttpURLConnection connection = null;
        BufferedReader text_in = null;
        PrintWriter text_out = null;
        InputStream binary_in = null;
        OutputStream binary_out = null;
        try {
            System.setProperty("java.net.useSystemProxies", "true");
            URL url = uri.toURL();
            List<Proxy> proxies = ProxySelector.getDefault().select(uri);
            Proxy proxy = null;
            if (proxies != null && !proxies.isEmpty()) {
                proxy = proxies.get(0);
                connection = (HttpURLConnection)url.openConnection(proxy);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            if (file.isDirectory()) {
                String filename = new File(url.getFile()).getName();
                if (filename.isEmpty()) {
                    Const.log.info((Object)"No file name specified and no file name found in URL.");
                    return false;
                }
                file = new File(file, filename);
            }
            int responseCode = connection.getResponseCode();
            String responseMessage = connection.getResponseMessage();
            InetSocketAddress addr = null;
            if (proxy != null) {
                addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    Const.log.info((Object)("Downloading '" + url + "' to file '" + file + "'"));
                } else {
                    Const.log.info((Object)("Downloading '" + url + "' with " + (Object)((Object)proxy.type()) + " proxy '" + addr.getHostName() + ":" + addr.getPort() + "' to file '" + file + "'"));
                }
            }
            if (responseCode == 407) {
                Const.log.info((Object)("HTTP " + responseCode + " " + responseMessage));
                Const.log.info((Object)"Checking system properties 'http.proxyUser' and 'http.proxyPassword' for credentials");
                String username = System.getProperty("http.proxyUser", "");
                String password = System.getProperty("http.proxyPassword", "");
                if (username.isEmpty()) {
                    Const.log.info((Object)"System property 'http.proxyUser' was empty - asking user");
                    JPanel panel = new JPanel(new GridLayout(2, 2));
                    panel.add(new JLabel("Username:"));
                    final JTextField usernameField = new JTextField();
                    panel.add(usernameField);
                    panel.add(new JLabel("Password:"));
                    JPasswordField passwordField = new JPasswordField();
                    panel.add(passwordField);
                    JOptionPane pane = new JOptionPane(panel, 1, 2);
                    JDialog dia = pane.createDialog(null, String.valueOf(addr.getHostName()) + ":" + addr.getPort());
                    dia.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowActivated(WindowEvent e) {
                            Timer timer = new Timer(50, ev -> {
                                boolean bl = usernameField.requestFocus(false);
                            });
                            timer.setRepeats(false);
                            timer.start();
                        }
                    });
                    dia.setVisible(true);
                    Object selectedValue = pane.getValue();
                    if (!(selectedValue instanceof Integer) || (Integer)selectedValue != 0) {
                        Const.log.info((Object)"Action cancelled by user.");
                        return false;
                    }
                    username = usernameField.getText();
                    password = passwordField.getText();
                    System.setProperty("http.proxyUser", username);
                    System.setProperty("http.proxyPassword", password);
                }
                final String finalUsername = username;
                final String finalPassword = password;
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(finalUsername, finalPassword.toCharArray());
                    }
                });
                Const.log.info((Object)("Trying proxy authentication with user '" + finalUsername + "' and password '" + finalPassword + "'"));
                connection = (HttpURLConnection)url.openConnection(proxy);
                responseCode = connection.getResponseCode();
                responseMessage = connection.getResponseMessage();
                if (responseCode != 200) {
                    Const.log.info((Object)("HTTP " + responseCode + " " + responseMessage));
                }
            }
            String contentType = connection.getContentType();
            int contentLength = connection.getContentLength();
            Const.log.info((Object)("Content type is '" + contentType + "'" + (contentLength < 0 ? "" : " with length " + contentLength)));
            if (contentType != null && contentType.toLowerCase().startsWith("text/")) {
                String inputLine;
                text_in = new BufferedReader(new InputStreamReader(url.openStream()));
                text_out = new PrintWriter(file);
                Const.log.info((Object)"Downloading as text");
                while ((inputLine = text_in.readLine()) != null) {
                    text_out.println(inputLine);
                }
            } else {
                int read;
                binary_in = connection.getInputStream();
                binary_out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[65536];
                int contentRead = 0;
                Const.log.info((Object)"Downloading as binary");
                while ((read = binary_in.read(buffer)) != -1) {
                    binary_out.write(buffer, 0, read);
                    contentRead += read;
                }
                if (contentRead < contentLength) {
                    Const.log.info((Object)("Warning: only got " + contentRead + " of " + contentLength + " bytes"));
                }
            }
            responseCode = connection.getResponseCode();
            responseMessage = connection.getResponseMessage();
            Const.log.info((Object)("HTTP " + responseCode + " " + responseMessage));
            Const.log.info((Object)"");
            boolean bl = responseCode == 200;
            return bl;
        }
        catch (Exception e) {
            Const.log.warn((Object)("Error while downloading '" + uri + "': " + e.getMessage() + "."));
            return false;
        }
        finally {
            if (oldValueOf_useSystemProxies != null) {
                System.setProperty("java.net.useSystemProxies", oldValueOf_useSystemProxies);
            }
            if (text_in != null) {
                try {
                    text_in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (text_out != null) {
                text_out.close();
            }
            if (binary_in != null) {
                try {
                    binary_in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (binary_out != null) {
                try {
                    binary_out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static boolean isDownloadableFiletype(String filename) {
        FileTools.getExtension(filename);
        int len = FileTools.getExtension(filename).length();
        return len > 0 && len <= 5 && !Const.EXTENSIONS_NODOWNLOAD.matches(filename);
    }
}

